/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.ars_nouveau.geckolib3.compat.PatchouliCompat;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatableModel;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.model.provider.data.EntityModelData;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.IRenderCycle;

public abstract class GeoReplacedEntityRenderer<T extends IAnimatable>
extends EntityRenderer
implements IGeoRenderer {
    protected final AnimatedGeoModel<IAnimatable> modelProvider;
    protected T animatable;
    protected final List<GeoLayerRenderer> layerRenderers = Lists.newArrayList();
    protected IAnimatable currentAnimatable;
    protected static final Map<Class<? extends IAnimatable>, GeoReplacedEntityRenderer> renderers = new ConcurrentHashMap<Class<? extends IAnimatable>, GeoReplacedEntityRenderer>();
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;
    protected MultiBufferSource rtb = null;

    @Override
    @Nonnull
    @ApiStatus.AvailableSince(value="3.0.42")
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    public GeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animatable) {
        super(renderManager);
        this.modelProvider = modelProvider;
        this.animatable = animatable;
        if (!renderers.containsKey(animatable.getClass())) {
            renderers.put(animatable.getClass(), this);
        }
    }

    public static GeoReplacedEntityRenderer getRenderer(Class<? extends IAnimatable> item) {
        return renderers.get(item);
    }

    @ApiStatus.AvailableSince(value="3.0.42")
    public float getWidthScale(Object animatable2) {
        return this.widthScale;
    }

    @ApiStatus.AvailableSince(value="3.0.42")
    public float getHeightScale(Object entity) {
        return this.heightScale;
    }

    public void m_7392_(Entity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.render(entityIn, (IAnimatable)this.animatable, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public void render(Entity entity, IAnimatable animatable, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        Entity leashHolder;
        this.currentAnimatable = animatable;
        if (!(entity instanceof LivingEntity)) {
            throw new RuntimeException("Replaced renderer was not an instanceof LivingEntity");
        }
        LivingEntity entityLiving = (LivingEntity)entity;
        this.dispatchedMat = stack.m_85850_().m_85861_().m_27658_();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        stack.m_85836_();
        if (entity instanceof Mob && (leashHolder = ((Mob)entity).m_21524_()) != null) {
            this.renderLeash((Mob)entity, partialTicks, stack, bufferIn, leashHolder);
        }
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entityLiving.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entityLiving.f_20884_, (float)entityLiving.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entityLiving.f_20886_, (float)entityLiving.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.m_146909_());
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entityLiving.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            stack.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.handleRotationFloat(entityLiving, partialTicks);
        this.applyRotations(entityLiving, stack, f7, f, partialTicks);
        this.preRenderCallback(entityLiving, stack, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            limbSwingAmount = Mth.m_14179_((float)partialTicks, (float)entityLiving.f_20923_, (float)entityLiving.f_20924_);
            limbSwing = entityLiving.f_20925_ - entityLiving.f_20924_ * (1.0f - partialTicks);
            if (entityLiving.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        entityModelData.headPitch = -f6;
        entityModelData.netHeadYaw = -f2;
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        AnimationEvent<IAnimatable> predicate = new AnimationEvent<IAnimatable>(animatable, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(animatable, this.getUniqueID(entity), (AnimationEvent)predicate);
        }
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.m_5478_(entity));
        Color renderColor = this.getRenderColor(animatable, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entity, partialTicks, stack, bufferIn, null, packedLightIn, this.m_5478_(entity));
        if (!entity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            VertexConsumer translucentBuffer;
            VertexConsumer glintBuffer = bufferIn.m_6299_(RenderType.m_110499_());
            this.render(model, entity, partialTicks, renderType, stack, bufferIn, glintBuffer != (translucentBuffer = bufferIn.m_6299_(RenderType.m_110470_((ResourceLocation)this.m_5478_(entity)))) ? VertexMultiConsumer.m_86168_((VertexConsumer)glintBuffer, (VertexConsumer)translucentBuffer) : null, packedLightIn, GeoReplacedEntityRenderer.getPackedOverlay(entityLiving, this.getOverlayProgress(entityLiving, partialTicks)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!entity.m_5833_()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(stack, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, f7, f2, f6);
            }
        }
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded(stack);
        }
        stack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    public void renderEarly(Object animatable, PoseStack stackIn, float partialTicks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = stackIn.m_85850_().m_85861_().m_27658_();
        IGeoRenderer.super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f boneMat = entry.m_85861_().m_27658_();
            Matrix4f renderEarlyMatInvert = this.renderEarlyMat.m_27658_();
            renderEarlyMatInvert.m_27657_();
            Matrix4f modelPosBoneMat = boneMat.m_27658_();
            modelPosBoneMat.multiplyBackward(renderEarlyMatInvert);
            bone.setModelSpaceXform(modelPosBoneMat);
            Matrix4f dispatchedMatInvert = this.dispatchedMat.m_27658_();
            dispatchedMatInvert.m_27657_();
            Matrix4f localPosBoneMat = boneMat.m_27658_();
            localPosBoneMat.multiplyBackward(dispatchedMatInvert);
            Vec3 renderOffset = this.m_7860_((Entity)this.animatable, 1.0f);
            localPosBoneMat.m_27648_(new Vector3f((float)renderOffset.m_7096_(), (float)renderOffset.m_7098_(), (float)renderOffset.m_7094_()));
            bone.setLocalSpaceXform(localPosBoneMat);
            Matrix4f worldPosBoneMat = localPosBoneMat.m_27658_();
            worldPosBoneMat.m_27648_(new Vector3f((float)((Entity)this.animatable).m_20185_(), (float)((Entity)this.animatable).m_20186_(), (float)((Entity)this.animatable).m_20189_()));
            bone.setWorldSpaceXform(worldPosBoneMat);
        }
        IGeoRenderer.super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected float getOverlayProgress(LivingEntity livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(LivingEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
    }

    public ResourceLocation m_5478_(Entity entity) {
        return this.getTextureLocation(this.currentAnimatable);
    }

    @Override
    public AnimatedGeoModel getGeoModelProvider() {
        return this.modelProvider;
    }

    public static int getPackedOverlay(LivingEntity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((livingEntityIn.f_20916_ > 0 || livingEntityIn.f_20919_ > 0 ? 1 : 0) != 0));
    }

    protected void applyRotations(LivingEntity entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        Pose pose = entityLiving.m_20089_();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (entityLiving.f_20919_ > 0) {
            float f = ((float)entityLiving.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * this.getDeathMaxRotation(entityLiving)));
        } else if (entityLiving.m_21209_()) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - entityLiving.m_146909_()));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(((float)entityLiving.f_19797_ + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.m_21259_();
            float f1 = direction != null ? GeoReplacedEntityRenderer.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(this.getDeathMaxRotation(entityLiving)));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        } else if ((entityLiving.m_8077_() || entityLiving instanceof Player) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_((String)entityLiving.m_7755_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof Player) || ((Player)entityLiving).m_36170_(PlayerModelPart.CAPE))) {
            matrixStackIn.m_85837_(0.0, (double)(entityLiving.m_20206_() + 0.1f), 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected boolean isVisible(LivingEntity livingEntityIn) {
        return !livingEntityIn.m_20145_();
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getDeathMaxRotation(LivingEntity entityLivingBaseIn) {
        return 90.0f;
    }

    public boolean m_6512_(Entity entity) {
        float f;
        double d0 = this.f_114476_.m_114471_(entity);
        float f2 = f = entity.m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        return entity == this.f_114476_.f_114359_ && entity.m_8077_() && Minecraft.m_91404_();
    }

    protected float getSwingProgress(LivingEntity livingBase, float partialTickTime) {
        return livingBase.m_21324_(partialTickTime);
    }

    protected float handleRotationFloat(LivingEntity livingBase, float partialTicks) {
        return (float)livingBase.f_19797_ + partialTicks;
    }

    public ResourceLocation getTextureLocation(Object instance) {
        return this.modelProvider.getTextureLocation((IAnimatable)instance);
    }

    public final boolean addLayer(GeoLayerRenderer<? extends LivingEntity> layer) {
        return this.layerRenderers.add(layer);
    }

    public <E extends Entity> void renderLeash(Mob entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, E leashHolder) {
        int u;
        poseStack.m_85836_();
        Vec3 vec3d = leashHolder.m_7398_(partialTicks);
        double d = (double)(Mth.m_14179_((float)partialTicks, (float)entity.f_20883_, (float)entity.f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec3d2 = entity.m_7939_();
        double e = Math.cos(d) * vec3d2.f_82481_ + Math.sin(d) * vec3d2.f_82479_;
        double f = Math.sin(d) * vec3d2.f_82481_ - Math.cos(d) * vec3d2.f_82479_;
        double g = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_()) + e;
        double h = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + vec3d2.f_82480_;
        double i = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_()) + f;
        poseStack.m_85837_(e, vec3d2.f_82480_, f);
        float j = (float)(vec3d.f_82479_ - g);
        float k = (float)(vec3d.f_82480_ - h);
        float l = (float)(vec3d.f_82481_ - i);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float n = Mth.m_14195_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.m_20299_(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolder.m_20299_(partialTicks));
        int q = this.m_6086_((Entity)entity, blockPos);
        int r = leashHolder.m_6060_() ? 15 : leashHolder.f_19853_.m_45517_(LightLayer.BLOCK, blockPos2);
        int s = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int t = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        poseStack.m_85849_();
    }

    private static void renderLeashPiece(VertexConsumer vertexConsumer, Matrix4f positionMatrix, float f, float g, float h, int leashedEntityBlockLight, int holdingEntityBlockLight, int leashedEntitySkyLight, int holdingEntitySkyLight, float i, float j, float k, float l, int pieceIndex, boolean isLeashKnot) {
        float m = (float)pieceIndex / 24.0f;
        int n = (int)Mth.m_14179_((float)m, (float)leashedEntityBlockLight, (float)holdingEntityBlockLight);
        int o = (int)Mth.m_14179_((float)m, (float)leashedEntitySkyLight, (float)holdingEntitySkyLight);
        int p = LightTexture.m_109885_((int)n, (int)o);
        float q = pieceIndex % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * q;
        float s = 0.4f * q;
        float t = 0.3f * q;
        float u = f * m;
        float v = g > 0.0f ? g * m * m : g - g * (1.0f - m) * (1.0f - m);
        float w = h * m;
        vertexConsumer.m_85982_(positionMatrix, u - k, v + j, w + l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
        vertexConsumer.m_85982_(positionMatrix, u + k, v + i - j, w - l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
    }

    @Override
    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            GeoReplacedEntityRenderer renderer = renderers.get(object.getClass());
            return renderer == null ? null : renderer.getGeoModelProvider();
        });
    }
}

